import static com.xebialabs.restito.builder.stub.StubHttp.whenHttp;
import static com.xebialabs.restito.semantics.Condition.custom;
import static com.xebialabs.restito.semantics.Condition.method;

import java.io.IOException;
import java.util.Date;

import org.glassfish.grizzly.http.Method;
import org.glassfish.grizzly.http.server.Request;
import org.glassfish.grizzly.http.server.Response;
import org.glassfish.grizzly.http.util.HttpStatus;
import org.joda.time.DateTime;
import org.joda.time.Days;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

import com.xebialabs.restito.semantics.Call;
import com.xebialabs.restito.semantics.Function;
import com.xebialabs.restito.semantics.Predicate;
import com.xebialabs.restito.server.StubServer;

public class AvailableAppointmentSlotsMock extends AbstractMock {
    private static String appointmentTimeSlotTemplate;
    private static String availableAppointmentSlotsPerClinic;

    public AvailableAppointmentSlotsMock() {
        appointmentTimeSlotTemplate = loadTemplate("appointment-time-slot.txt");
        availableAppointmentSlotsPerClinic = loadTemplate("available-appointment-slots-per-clinic.txt");
    }

    @Override
    public void run(StubServer server) {
        Predicate<Call> validUri = new Predicate<Call>() {
            @Override
            public boolean apply(final Call input) {
                return input.getUri().matches(".*/available-appointment-slots");
            }
        };

        Function<Response, Response> response = new Function<Response, Response>() {
            @Override
            public Response apply(Response input) {
                Request request = input.getRequest();

                String uri = request.getRequestURI();
                String siteCodeRegex = ".*/site/(\\d+)/patient";
                String patientIdRegex = ".*/EDIPI/(.*)/available-appointment-slots";
                String siteCode = matchingRegex(uri, siteCodeRegex);
                String patientId = matchingRegex(uri, patientIdRegex);

                Date startDate = parse(request.getParameter("startDate"));
                Date endDate   = parse(request.getParameter("endDate"));
                String clinicIds = request.getParameter("clinicIds");
                String output = "";

                try {
                    output = createAppointmentSlots(startDate, endDate, clinicIds, 30, true);
                    input.getWriter().write(output);
                } catch (IOException e) {
                    e.printStackTrace();
                }
                return input;
            }
        };

        whenHttp(server).match(custom(validUri), method(Method.GET))
            .then(generateResponse(HttpStatus.OK_200, response));
    }

    private String createAppointmentSlots(Date startDate, Date endDate, String clinicIds, int appointmentLength, boolean hasSlots) {
        return validDates(startDate, endDate) ?
            "[" + createAppointmentSlotsPerClinicId(startDate, endDate, clinicIds, appointmentLength, hasSlots) + "]" :
            "invalid dates";
    }

    private String createAppointmentSlotsPerClinicId(Date startDate, Date endDate, String clinicIds, int appointmentLength, boolean hasSlots) {
        StringBuffer result = new StringBuffer();

        String[] clinics = clinicIds.split(",");
        for(int i=0; i<clinics.length; i++) {
            String clinicId = clinics[i];
            String clinicName = "MOCK CLINIC NAME " + clinicId;
            long numSlots = clinicId.equals("458") ? 0 : -1;

            result.append(String.format(availableAppointmentSlotsPerClinic, numSlots, clinicId, clinicName,
                appointmentLength, hasSlots ? createAppointmentSlotsPerDay(clinicId, startDate, endDate) : ""));
            if(i < clinics.length -1) result.append(",");
        }
        return result.toString();
    }

    public String createAppointmentSlotsPerDay(String clinicId, Date startDate, Date endDate) {
        StringBuffer result = new StringBuffer();

        if(clinicId.equals("458")) {
            return result.toString();
        }

        DateTime startDateTime = new DateTime(startDate);
        DateTime endDateTime   = new DateTime(endDate);

        for(DateTime d=startDateTime; d.toDate().compareTo(endDateTime.toDate()) <= 0 ; d=d.plusDays(1)) {
            if(Days.daysBetween(d, startDateTime).getDays() % 3 == 0) {
                continue;
            }

            result.append(createAppointmentSlotsPer30minutes(d.toDate()));
            if(d.toDate().compareTo(endDate) < 0) result.append(",");
        }
        return result.toString();
    }

    private StringBuffer createAppointmentSlotsPer30minutes(Date date) {
        StringBuffer result = new StringBuffer();
        String day = formatDate(date);
        DateTime dt = new DateTime(date.getTime());
        DateTimeFormatter formatter = DateTimeFormat.forPattern(" HH:mm:ss");

        String startTime, endTime;
        for(int m=480; m<1020; m+=30) { // 8:00 - 17:00 (18 slots per day)
            startTime = day + formatter.print(dt.plusMinutes(m));
            endTime = day + formatter.print(dt.plusMinutes(m).plusMinutes(30));
            result.append(String.format(appointmentTimeSlotTemplate, startTime, endTime));
            if(m < 1020 -30) result.append(",");
        }
        return result;
    }

    private boolean validDates(Date startDate, Date endDate) {
        return true;
//        return (startDate != null) && (endDate != null) && (endDate.compareTo(startDate) >= 0)
//            && (startDate.compareTo(today.toDate()) >= 0);
    }
}
